/******************************************************************************/
/******************************************************************************/

//  FiveCo        Innovative Engineering

//  Switzerland                     2006

/******************************************************************************/
/******************************************************************************/
//---------------------------------------------------------------------------
#ifndef MainFormH
#define MainFormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <ExtCtrls.hpp>
//---------------------------------------------------------------------------
#include "FMod_TCP_BOX_DLLInterface.h"
//---------------------------------------------------------------------------
#define     RECEIVEBUFFERSIZE   256
//---------------------------------------------------------------------------
class TForm1 : public TForm
{
__published:	// IDE-managed Components
    TGroupBox *GroupBox1;
    TEdit *EAddress1ComMain;
    TButton *BOpenComMain;
    TButton *BCloseComMain;
    TButton *BSendRWComMain;
    TStatusBar *SBComMain;
    TMemo *MemoComMain;
    TGroupBox *GroupBox2;
    TButton *BOpenComRS232;
    TButton *BCloseComRS232;
    TButton *BSendComRS232;
    TStatusBar *SBComRS232;
    TMemo *MemoComRS232;
    TButton *BSendRComMain;
    TButton *BSendWComMain;
    TButton *BSendI2CMain;
    TButton *BStartRepet;
    TButton *BStopRepet;
    TButton *BSetTimeRepet;
    TEdit *ETimeRepet;
    TLabel *LTimeRepet;
    TLabel *Label1;
    TEdit *EAddress2ComMain;
    TEdit *EAddress3ComMain;
    TEdit *EAddress4ComMain;
    TEdit *EAddress1ComRS232;
    TEdit *EAddress2ComRS232;
    TEdit *EAddress3ComRS232;
    TEdit *EAddress4ComRS232;
    TGroupBox *GroupBox3;
    TButton *BScanNetwork;
    TButton *BChangeIPAdd;
    TEdit *ENewAddress1;
    TEdit *ENewAddress2;
    TEdit *ENewAddress3;
    TEdit *ENewAddress4;
    TStatusBar *SBForm;
    TStatusBar *SBComGeneral;
    void __fastcall BOpenComMainClick(TObject *Sender);
    void __fastcall BCloseComMainClick(TObject *Sender);
    void __fastcall BSendRWComMainClick(TObject *Sender);
    void __fastcall BOpenComRS232Click(TObject *Sender);
    void __fastcall BCloseComRS232Click(TObject *Sender);
    void __fastcall BSendComRS232Click(TObject *Sender);
    void __fastcall BSendRComMainClick(TObject *Sender);
    void __fastcall BSendWComMainClick(TObject *Sender);
    void __fastcall BSendI2CMainClick(TObject *Sender);
    void __fastcall BStartRepetClick(TObject *Sender);
    void __fastcall BStopRepetClick(TObject *Sender);
    void __fastcall BSetTimeRepetClick(TObject *Sender);
    void __fastcall BScanNetworkClick(TObject *Sender);
    void __fastcall BChangeIPAddClick(TObject *Sender);
private:	// User declarations

public:		// User declarations
    __fastcall TForm1(TComponent* Owner);
    __fastcall ~TForm1();

    /*******************************************/
    //  MAIN PORT
    /*******************************************/
    void *ComID_MAIN;

    // Callback functions
    void Data_Received_MAIN(FMod_SRegisterListRead *RegList, void *ComID);
    void Com_Event_MAIN(int State, void *ComID);

    /*******************************************/
    //  RS232 PORT
    /*******************************************/
    void *ComID_RS232;

    Byte DataReceived_RS232[RECEIVEBUFFERSIZE];

    // Com2 Event
    void Data_Received_RS232(int NbByte, void *ComID);
    void Com_Event_RS232(int State, void *ComID);

    /*******************************************/

    void TranslateState(int State, AnsiString *StateStr);

    // Variable to mesure time between to received data
    LARGE_INTEGER Time1, Time2, Frequency;
    int Cpt;
    float Val;
};
//---------------------------------------------------------------------------
extern PACKAGE TForm1 *Form1;
//---------------------------------------------------------------------------
#endif
